<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

include('config.php');

// Get the current time and the timestamp for 24 hours ago
$now = date('Y-m-d H:i:s');
$yesterday = date('Y-m-d H:i:s', strtotime('-24 hours'));

// Initialize totals
$total_deposits = 0.00;
$total_withdrawals = 0.00;

// ------------------- DEPOSITS -------------------
// ✅ Use only wallet_deposit table (approved deposits in last 24 hours)
$walletDepositSql = "SELECT SUM(deposit_amount) AS total FROM wallet_deposit 
                     WHERE Status = 1 
                     AND deposed_date BETWEEN '$yesterday' AND '$now'";
$walletDepositResult = $conn->query($walletDepositSql);
if ($row = $walletDepositResult->fetch_assoc()) {
    $total_deposits = floatval($row['total']);
}

// ------------------- WITHDRAWALS -------------------
// ✅ Use only wallet_withdraw table (approved withdrawals in last 24 hours)
$walletWithdrawSql = "SELECT SUM(withdraw_amount) AS total FROM wallet_withdraw 
                      WHERE Status = 1 
                      AND withdraw_date BETWEEN '$yesterday' AND '$now'";
$walletWithdrawResult = $conn->query($walletWithdrawSql);
if ($row = $walletWithdrawResult->fetch_assoc()) {
    $total_withdrawals = floatval($row['total']);
}

// ------------------- NET DEPOSIT -------------------

$net_deposit = $total_deposits - $total_withdrawals;

// ------------------- RESPONSE -------------------

$response = [
    'success' => true,
    'period' => [
        'from' => $yesterday,
        'to' => $now
    ],
    'totals' => [
        'total_deposits' => round($total_deposits, 2),
        'total_withdrawals' => round($total_withdrawals, 2),
        'net_deposit' => round($net_deposit, 2)
    ]
];

echo json_encode($response, JSON_PRETTY_PRINT);
?>
